/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.AdaptedRemoteWatcher;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.RemoteWatchable;
import ibm.nways.jdm.RemoteWatcherAdapter;
import ibm.nways.jdm.StatusData;
import ibm.nways.jdm.StatusImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.Watcher;
import java.rmi.server.UnicastRemoteObject;

public class StatusProxy
extends StatusImpl
implements AdaptedRemoteWatcher {
    private RemoteStatus remoteStatus;
    private RemoteWatcherAdapter watcherAdapter;

    public StatusProxy(RemoteStatus remoteStatus) {
        this.remoteStatus = remoteStatus;
        try {
            this.watcherAdapter = new RemoteWatcherAdapter(this);
            UnicastRemoteObject.exportObject(this.watcherAdapter);
            StatusData statusData = remoteStatus.getStatusData();
            this.setStatusType(statusData.getStatusType(), statusData.getExplanation(), true);
            this.setName(statusData.getName());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void update(RemoteWatchable remoteWatchable, Object object) {
        if (object instanceof StatusData) {
            StatusData statusData = (StatusData)object;
            this.setStatusType(statusData.getStatusType(), statusData.getExplanation(), true);
        }
    }

    public StatusType check() {
        try {
            this.remoteStatus.check();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.getStatusType();
    }

    protected RemoteStatus getRemoteStatus() {
        return this.remoteStatus;
    }

    public synchronized void addWatcher(Watcher watcher) {
        try {
            this.remoteStatus.addWatcher(this.watcherAdapter);
            StatusData statusData = this.remoteStatus.getStatusData();
            this.setStatusType(statusData.getStatusType(), statusData.getExplanation(), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.addWatcher(watcher);
    }

    public synchronized void deleteWatcher(Watcher watcher) {
        super.deleteWatcher(watcher);
        this.optimizeDeleteWatcher();
    }

    public void deleteWatchers() {
        super.deleteWatchers();
        this.optimizeDeleteWatcher();
    }

    private void optimizeDeleteWatcher() {
        if (this.countWatchers() == 0) {
            try {
                this.remoteStatus.deleteWatcher(this.watcherAdapter);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public void dispose() {
        if (this.remoteStatus != null && this.watcherAdapter != null) {
            try {
                this.remoteStatus.deleteWatcher(this.watcherAdapter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.remoteStatus = null;
            this.watcherAdapter = null;
        }
    }
}

